resource "aws_iam_role" "squirro" {
  name = "squirro-ec2-role"
  assume_role_policy = jsonencode({
    Version = "2012-10-17"
    Statement = [
      {
        Action = "sts:AssumeRole"
        Effect = "Allow"
        Principal = {
          Service = "ec2.amazonaws.com"
        }
      },
      {
        Action = "sts:AssumeRole"
        Effect = "Allow"
        Principal = {
          Service = "ssm.amazonaws.com"
        }
      }
    ]
  })
}

resource "aws_iam_role_policy_attachment" "squirro_ssm" {
  role       = aws_iam_role.squirro.name
  policy_arn = "arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore"
}

resource "aws_iam_instance_profile" "squirro" {
  name = "squirro-ec2-role"
  role = aws_iam_role.squirro.name
}

resource "aws_instance" "squirro" {
  ami                         = var.base_ami_id
  instance_type               = var.machine_size
  monitoring                  = false
  subnet_id                   = aws_subnet.public.0.id
  vpc_security_group_ids      = [aws_security_group.squirro.id]
  associate_public_ip_address = true
  source_dest_check           = true
  iam_instance_profile        = aws_iam_instance_profile.squirro.name
  user_data                   = templatefile("${path.module}/user_data.tpl", { env = var.env, subdomain = var.subdomain, username = var.username })

  root_block_device {
    volume_type = "gp3"
    volume_size = var.machine_root_volume_size
    encrypted   = true
  }

  tags = tomap({
    "Name"      = "${var.env}-squirro",
    "Terraform" = "True",
    "Snapshot"  = "True",
  })
}

resource "aws_eip_association" "squirro" {
  instance_id   = aws_instance.squirro.id
  allocation_id = aws_eip.squirro.id
}

resource "aws_eip" "squirro" {
  domain = "vpc"
  tags = {
    Name = "${var.env}-squirro-eip"
  }
}

resource "aws_security_group" "squirro" {
  name        = "${var.env}-squirro"
  description = "Security group for ec2"
  vpc_id      = data.aws_vpc.existing.id

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  # ingress {
  #   cidr_blocks = [for num in var.ssh_ips : upper(num)]
  #   description = "SSH"
  #   from_port   = 22
  #   to_port     = 22
  #   protocol    = "TCP"
  # }

  ingress {
    cidr_blocks = ["100.0.0.0/8"]
    description = "HTTPS"
    from_port   = 443
    to_port     = 443
    protocol    = "TCP"
  }

  tags = tomap({
    "Name" = "${var.env}-squirro"
  })
}
