# terraform-aws
AWS Terraform Module to Deploy Squirro

This Terraform module deploys a Squirro instance on AWS using an existing VPC. The module creates an EC2 instance with appropriate IAM roles, security groups, and networking configuration.

## Architecture

![Architecture Diagram](./architecture.png)

## Prerequisites

- Existing AWS VPC with Internet Gateway
- Appropriate AMI ID for Squirro deployment
- AWS CLI configured with appropriate permissions
- Terraform >= 1.0

## Usage

1. Copy `terraform.tfvars.example` to `terraform.tfvars`:
   ```bash
   cp terraform.tfvars.example terraform.tfvars
   ```

2. Update `terraform.tfvars` with your specific values

3. Initialize and apply Terraform:
   ```bash
   terraform init
   terraform plan
   terraform apply
   ```

## Variables

| Variable | Type | Description | Required | Example |
|----------|------|-------------|----------|---------|
| `env` | string | Environment name used for resource naming and tagging | Yes | `"test"` |
| `machine_size` | string | EC2 instance type for the Squirro server | Yes | `"m6i.2xlarge"` |
| `base_ami_id` | string | AMI ID to use for the EC2 instance | Yes | `"ami-012ca946ca60e62e0"` |
| `aws_region` | string | AWS region where resources will be created | Yes | `"eu-central-2"` |
| `username` | string | Username for deployment (used in user data script) | Yes | `"ansible_deploy"` |
| `machine_root_volume_size` | string | Size of the root EBS volume in GB | Yes | `"200"` |
| `subdomain` | string | Subdomain prefix for hostname configuration | Yes | `"war-test"` |
| `vpc_id` | string | ID of the existing VPC to use | Yes | `"vpc-029f073427cb6bc8b"` |
| `public_subnets_list` | list(string) | List of CIDR blocks for public subnets to create | Yes | `["172.31.64.0/24"]` |

### Optional Variables (Currently Commented Out)

The following variables are defined but commented out for future use with Terraform Cloud or sensitive data management:

- `yum_user` - Username for YUM repository access
- `yum_password` - Password for YUM repository access  
- `es_auth_password` - Elasticsearch authentication password
- `mysql_shared_service_password` - MySQL shared service password
- `openai_key` - OpenAI API key

## Resources Created

This module creates the following AWS resources:

- **EC2 Instance**: Squirro server with encrypted EBS root volume
- **Elastic IP**: Static IP address for the instance
- **Security Group**: Allows HTTPS traffic from 100.0.0.0/8 and all outbound traffic
- **IAM Role & Instance Profile**: EC2 role with SSM permissions for remote management
- **Public Subnet(s)**: New subnet(s) in the existing VPC
- **Route Table**: Routes traffic through existing Internet Gateway

## Security Features

- Encrypted EBS root volume
- IAM role with minimal required permissions (SSM access)
- Security group restricts inbound access to HTTPS from private networks only
- SSM agent installed for secure remote access

## User Data Script

The module includes a user data script (`user_data.tpl`) that:
- Sets the hostname based on subdomain
- Installs and configures SSM agent
- Updates the OS and installs essential packages
- Creates vim symlink to neovim
- Handles automatic reboots if required
